package cn.schoolwow.quickhttp.module.response.body.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.common.HttpRequestContext;
import okhttp3.Response;

import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;

public class CloseHttpResponseServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        switch (httpClientOption.httpExecuteEngine){
            case Raw:{
                saveKeepAliveSocket(flowContext);
            }break;
            case OkHttp:{
                Response response = flowContext.checkInstanceData(Response.class);
                response.close();
            }break;
        }
    }

    @Override
    public String name() {
        return "关闭http连接";
    }

    private void saveKeepAliveSocket(FlowContext flowContext){
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpRequestContext httpRequestContext = flowContext.checkInstanceData(HttpRequestContext.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);
        
        if(httpResponseContext.headerMap.containsKey("Connection")&&httpResponseContext.headerMap.get("Connection").get(0).equalsIgnoreCase("close")){
            return;
        }
        if(flowContext.containKey("testConnection")){
            return;
        }

        int port = httpRequestOption.url.getPort()==-1?httpRequestOption.url.getDefaultPort():httpRequestOption.url.getPort();
        String socketKey = httpRequestOption.url.getProtocol()+"://"+httpRequestOption.url.getHost() + ":" + port;

        if(!httpClientOption.keepAliveSocketMap.containsKey(socketKey)){
            httpClientOption.keepAliveSocketMap.put(socketKey, new ArrayBlockingQueue<Socket>(5));
        }
        ArrayBlockingQueue<Socket> arrayBlockingQueue = httpClientOption.keepAliveSocketMap.get(socketKey);
        if(arrayBlockingQueue.size()<httpClientOption.maxIdleSocketConnection){
            arrayBlockingQueue.offer(httpRequestContext.socket);
            flowContext.log("[获取Socket链接]添加到空闲队列,当前空闲连接个数:"+arrayBlockingQueue.size()+",最大空闲队列个数:"+httpClientOption.maxIdleSocketConnection);
        }else{
            flowContext.log("[获取Socket链接]空闲队列已满,当前空闲连接个数:"+arrayBlockingQueue.size()+",最大空闲队列个数:"+httpClientOption.maxIdleSocketConnection);
        }
    }
}
