package cn.schoolwow.quickhttp.module.response.body.kit;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.execute.Response;
import cn.schoolwow.quickhttp.module.request.execute.domain.SpeedLimitInputStream;
import cn.schoolwow.quickhttp.module.response.HttpResponseParent;
import cn.schoolwow.quickhttp.module.response.body.service.HttpResponseBodyAsByteServiceFlow;
import cn.schoolwow.quickhttp.module.response.body.service.HttpResponseBodyAsFileServiceFlow;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class ResponseBodyImpl extends HttpResponseParent implements ResponseBody{
    public ResponseBodyImpl(QuickFlow quickFlow) {
        super(quickFlow);
    }
    
    @Override
    public Response maxDownloadSpeed(int maxDownloadSpeed) {
        if(null!=httpResponseContext.inputStream){
            SpeedLimitInputStream speedLimitInputStream = new SpeedLimitInputStream(httpResponseContext.inputStream);
            speedLimitInputStream.setMaxDownloadSpeed(maxDownloadSpeed);
            httpResponseContext.inputStream = speedLimitInputStream;
        }
        return response;
    }

    @Override
    public String body() {
        if (null == httpResponseContext.body) {
            bodyAsBytes();
        }
        return new String(httpResponseContext.body, Charset.forName(httpResponseContext.charset));
    }

    @Override
    public JSONObject bodyAsJSONObject() {
        JSONObject object = JSON.parseObject(body());
        return object;
    }

    @Override
    public <T> T bodyAsInstance(Class<T> classType) {
        return bodyAsJSONObject().toJavaObject(classType);
    }

    @Override
    public JSONArray bodyAsJSONArray() {
        JSONArray array = JSON.parseArray(body());
        return array;
    }

    @Override
    public <T> List<T> bodyAsInstanceList(Class<T> classType) {
        JSONArray array = bodyAsJSONArray();
        List<T> list = array.toJavaList(classType);
        return list;
    }

    @Override
    public JSONObject jsonpAsJSONObject() {
        String body = body();
        int startIndex = body.indexOf('(') + 1, endIndex = body.lastIndexOf(')');
        return JSON.parseObject(body.substring(startIndex, endIndex));
    }

    @Override
    public JSONArray jsonpAsJSONArray() {
        String body = body();
        int startIndex = body.indexOf('(') + 1, endIndex = body.lastIndexOf(')');
        return JSON.parseArray(body.substring(startIndex, endIndex));
    }

    @Override
    public byte[] bodyAsBytes() {
        quickFlow.startFlow(new HttpResponseBodyAsByteServiceFlow()).execute();
        return httpResponseContext.body;
    }

    @Override
    public void bodyAsFile(String filePath) {
        Path path = Paths.get(filePath);
        bodyAsFile(path);
    }

    @Override
    public File bodyAsFile() {
        try {
            File file = File.createTempFile("QuickHttp", "tmp");
            bodyAsFile(file.toPath());
            return file;
        }catch (IOException e){
            throw new RuntimeException(e);
        }
    }

    @Override
    public void bodyAsFile(Path file) {
        quickFlow.startFlow(new HttpResponseBodyAsFileServiceFlow())
                .putCurrentCompositeFlowData("file", file)
                .execute();
    }

    @Override
    public InputStream bodyStream() {
        return httpResponseContext.inputStream;
    }
}
