package cn.schoolwow.quickhttp.module.response.body.kit;

import cn.schoolwow.quickhttp.domain.execute.Response;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;

/**响应体*/
public interface ResponseBody {
    /**
     * 设置最大下载速率(kb/s)
     */
    Response maxDownloadSpeed(int maxDownloadSpeed);

    /**
     * 返回字符串
     */
    String body();

    /**
     * 返回JSON对象
     */
    JSONObject bodyAsJSONObject();

    /**
     * 返回实例
     */
    <T> T bodyAsInstance(Class<T> classType);

    /**
     * 返回JSON数组
     */
    JSONArray bodyAsJSONArray();

    /**
     * 返回实例数组
     */
    <T> List<T> bodyAsInstanceList(Class<T> classType);

    /**
     * 解析jsonp返回JSON对象
     */
    JSONObject jsonpAsJSONObject();

    /**
     * 解析jsonp返回JSON数组
     */
    JSONArray jsonpAsJSONArray();

    /**
     * 返回字节数组
     */
    byte[] bodyAsBytes();

    /**
     * 将输入流写入到指定文件
     * <p>若文件已存在,则会追加到文件尾部</p>
     */
    void bodyAsFile(String filePath);

    /**
     * 将输入流写入到指定文件
     */
    File bodyAsFile();

    /**
     * 将输入流写入到指定文件
     * <p>若文件已存在,则会追加到文件尾部</p>
     */
    void bodyAsFile(Path file);

    /**
     * 获取输入流
     */
    InputStream bodyStream();
}
