package cn.schoolwow.quickhttp.module.response;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.domain.execute.Response;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.common.HttpRequestContext;

public class HttpResponseParent {
    protected QuickFlow quickFlow;
    protected HttpRequestOption httpRequestOption;
    protected HttpRequestContext httpRequestContext;
    protected HttpResponseContext httpResponseContext;
    protected Response response;
    protected HttpClientOption httpClientOption;

    public HttpResponseParent(QuickFlow quickFlow) {
        this.quickFlow = quickFlow;
        this.httpRequestOption = quickFlow.getContextInstanceData(HttpRequestOption.class);
        this.httpRequestContext = quickFlow.getContextInstanceData(HttpRequestContext.class);
        this.httpResponseContext = quickFlow.getContextInstanceData(HttpResponseContext.class);
        this.response = quickFlow.getContextInstanceData(Response.class);
        this.httpClientOption = quickFlow.getContextInstanceData(HttpClientOption.class);
    }
}
