package cn.schoolwow.quickhttp.module.response;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.module.response.body.kit.ResponseBody;
import cn.schoolwow.quickhttp.module.response.body.kit.ResponseBodyImpl;
import cn.schoolwow.quickhttp.module.response.body.service.CloseHttpResponseServiceFlow;
import cn.schoolwow.quickhttp.module.response.header.kit.ResponseHeaderImpl;
import cn.schoolwow.quickhttp.module.response.option.ResponseOptionImpl;
import cn.schoolwow.quickhttp.module.response.parse.ResponseParseImpl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * http响应对象代理对象
 */
public class HttpResponseInvocationHandler implements InvocationHandler {
    private QuickFlow quickFlow;
    private Object[] interfaceInstanceArray;

    public HttpResponseInvocationHandler(QuickFlow quickFlow) {
        this.quickFlow = quickFlow;
        ResponseBody responseBody = new ResponseBodyImpl(quickFlow);
        interfaceInstanceArray = new Object[]{
                new ResponseHeaderImpl(quickFlow),
                responseBody,
                new ResponseParseImpl(responseBody,quickFlow),
                new ResponseOptionImpl(quickFlow),
        };
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        for(Object interfaceInstance:interfaceInstanceArray){
            Class interfaceClass = interfaceInstance.getClass().getInterfaces()[0];
            String currentInterfaceName = interfaceClass.getSimpleName();
            if("close".equals(method.getName())){
                quickFlow.executeFlowList(new CloseHttpResponseServiceFlow());
                return null;
            }else{
                if(currentInterfaceName.equalsIgnoreCase(interfaceName)){
                    try {
                        return method.invoke(interfaceInstance, args);
                    }catch (InvocationTargetException e){
                        Throwable targetException = e.getTargetException();
                        throw targetException;
                    }
                }
            }
        }
        throw new IllegalAccessError("不支持调用该方法!方法名:"+method.getName());
    }
}
