package cn.schoolwow.quickhttp.module.request.url.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;

import java.net.URL;

public class SetRequestUrlServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String url = flowContext.checkData("url", String.class);
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        if(null!=httpClientOption.origin&&!url.startsWith("http")){
            httpRequestOption.url = new URL(httpClientOption.origin + url);
        }else{
            httpRequestOption.url = new URL(url);
        }
    }

    @Override
    public String name() {
        return "设置请求地址服务流程";
    }
}
