package cn.schoolwow.quickhttp.module.request.url.kit;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.request.HttpRequestParent;
import cn.schoolwow.quickhttp.module.request.url.service.SetRequestUrlServiceFlow;

import java.net.URL;

public class RequestUrlImpl extends HttpRequestParent implements RequestUrl {

    public RequestUrlImpl(QuickFlow quickFlow) {
        super(quickFlow);
    }

    @Override
    public Request url(URL url) {
        httpRequestOption.url = url;
        return httpRequestContext.request;
    }

    @Override
    public Request url(String url) {
        quickFlow.startFlow(new SetRequestUrlServiceFlow())
                .putCurrentCompositeFlowData("url", url)
                .execute();
        return httpRequestContext.request;
    }

    @Override
    public Request method(String method) {
        for (Request.Method methodEnum : Request.Method.values()) {
            if (methodEnum.name().equalsIgnoreCase(method)) {
                httpRequestOption.method = methodEnum;
                return httpRequestContext.request;
            }
        }
        throw new IllegalArgumentException("不支持的请求方法!" + method);
    }

    @Override
    public Request method(Request.Method method) {
        httpRequestOption.method = method;
        return httpRequestContext.request;
    }

}
