package cn.schoolwow.quickhttp.module.request.option.service;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.util.QuickHttpUtil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CloneRequestServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(httpRequestOption);
        oos.close();

        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        HttpRequestOption cloneHttpRequestOption = (HttpRequestOption) ois.readObject();
        cloneHttpRequestOption.url = httpRequestOption.url;
        cloneHttpRequestOption.method = httpRequestOption.method;
        cloneHttpRequestOption.proxy = httpRequestOption.proxy;
        cloneHttpRequestOption.userContentType = httpRequestOption.userContentType;
        cloneHttpRequestOption.requestBody = httpRequestOption.requestBody;
        cloneHttpRequestOption.eventSourceConsumer = httpRequestOption.eventSourceConsumer;

        QuickFlow executeFlow = QuickFlowBuilder.newInstance()
                .putContextTemporaryInstanceData(cloneHttpRequestOption, HttpRequestOption.class)
                .parentFlow(flowContext.getQuickFlow().getParentFlow());
        Request cloneRequest = QuickHttpUtil.newRequestProxy(executeFlow);
        flowContext.putTemporaryData("cloneRequest", cloneRequest);
    }

    @Override
    public String name() {
        return "克隆Request对象服务流程";
    }
}
