package cn.schoolwow.quickhttp.module.request.option.kit;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.common.EventSource;
import cn.schoolwow.quickhttp.module.request.HttpRequestParent;
import cn.schoolwow.quickhttp.module.request.option.service.CloneRequestServiceFlow;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Consumer;

public class RequestOptionImpl extends HttpRequestParent implements RequestOption {
    public RequestOptionImpl(QuickFlow quickFlow) {
        super(quickFlow);
    }
    
    @Override
    public Request proxy(Proxy proxy) {
        httpRequestOption.proxy = proxy;
        httpRequestOption.headerMap.put("Proxy-Connection", Arrays.asList("Keep-Alive"));
        return httpRequestContext.request;
    }

    @Override
    public Request proxy(String host, int port) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        this.proxy(proxy);
        return httpRequestContext.request;
    }

    @Override
    public Request proxyAuth(String username, String password) {
        String encoded = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(Charset.forName(httpRequestOption.charset)));
        httpRequestOption.headerMap.put("Proxy-Authorization", Arrays.asList("Basic " + encoded));
        return httpRequestContext.request;
    }

    @Override
    public Request connectTimeout(int connectTimeoutMillis) {
        httpRequestOption.connectTimeoutMillis = connectTimeoutMillis;
        return httpRequestContext.request;
    }

    @Override
    public Request readTimeout(int readTimeoutMillis) {
        httpRequestOption.readTimeoutMillis = readTimeoutMillis;
        return httpRequestContext.request;
    }

    @Override
    public Request followRedirects(boolean followRedirects) {
        httpRequestOption.followRedirects = followRedirects;
        return httpRequestContext.request;
    }

    @Override
    public Request maxFollowRedirectTimes(int maxFollowRedirectTimes) {
        httpRequestOption.maxFollowRedirectTimes = maxFollowRedirectTimes;
        return httpRequestContext.request;
    }

    @Override
    public Request ignoreHttpErrors(boolean ignoreHttpErrors) {
        httpRequestOption.ignoreHttpErrors = ignoreHttpErrors;
        return httpRequestContext.request;
    }

    @Override
    public Request retryTimes(int retryTimes) {
        httpRequestOption.retryTimes = retryTimes;
        return httpRequestContext.request;
    }

    @Override
    public Request onEventSource(Consumer<EventSource> eventSourceConsumer) {
        httpRequestOption.eventSourceConsumer = eventSourceConsumer;
        return httpRequestContext.request;
    }

    @Override
    public Object getExtraData(String key) {
        Object value = httpRequestOption.extraMap.get(key);
        return value;
    }

    @Override
    public Request putExtraData(String key, Object value) {
        httpRequestOption.extraMap.put(key, value);
        return httpRequestContext.request;
    }

    @Override
    public Request clone() {
        FlowContext flowContext = quickFlow.startFlow(new CloneRequestServiceFlow()).execute();
        Request cloneRequest = flowContext.checkData("cloneRequest", Request.class);
        return cloneRequest;
    }

    @Override
    public HttpRequestOption getHttpRequestOption() {
        return httpRequestOption;
    }

    @Override
    public Request setHttpRequestOption(HttpRequestOption httpRequestOption) {
        this.httpRequestOption = httpRequestOption;
        return httpRequestContext.request;
    }

    @Override
    public QuickFlow getExecuteFlow() {
        return quickFlow;
    }
}
