package cn.schoolwow.quickhttp.module.request.option.kit;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.common.EventSource;

import java.net.Proxy;
import java.util.function.Consumer;

public interface RequestOption {
    /***
     * 设置代理
     * @param proxy 代理对象
     */
    Request proxy(Proxy proxy);

    /***
     * 设置代理
     * @param host 代理地址
     * @param port 代理端口
     */
    Request proxy(String host, int port);

    /**
     * 设置代理认证请求头部
     *
     * @param username 用户名
     * @param password 密码
     */
    Request proxyAuth(String username, String password);

    /**
     * 设置连接超时时间(毫秒)
     *
     * @param connectTimeoutMillis 连接超时时间(毫秒),0表示不限制
     */
    Request connectTimeout(int connectTimeoutMillis);

    /**
     * 设置读取超时时间(毫秒)
     *
     * @param readTimeoutMillis 读取超时时间(毫秒),0表示不限制
     **/
    Request readTimeout(int readTimeoutMillis);

    /**
     * 是否自动重定向
     *
     * @param followRedirects 是否自动重新定定向.默认为true
     */
    Request followRedirects(boolean followRedirects);

    /**
     * 指定最大重定向次数
     *
     * @param maxFollowRedirectTimes 最大重定向次数
     */
    Request maxFollowRedirectTimes(int maxFollowRedirectTimes);

    /**
     * 是否忽略http错误(4xx和5xx响应码)
     *
     * @param ignoreHttpErrors 忽略http错误,默认为false
     */
    Request ignoreHttpErrors(boolean ignoreHttpErrors);

    /**
     * <b>请求超时</b>时重试次数
     *
     * @param retryTimes 重试次数,默认为3次
     */
    Request retryTimes(int retryTimes);

    /**
     * 处理EventSource事件
     * @param eventSourceConsumer EventSource回调函数
     * */
    Request onEventSource(Consumer<EventSource> eventSourceConsumer);

    /**
     * 获取额外属性
     * @param key 额外属性键
     * */
    Object getExtraData(String key);

    /**
     * 设置额外属性
     * @param key 额外属性键
     * @param value 额外属性值
     * */
    Request putExtraData(String key, Object value);

    /**
     * clone方法
     */
    Request clone();

    /**
     * 获取请求参数
     * */
    HttpRequestOption getHttpRequestOption();

    /**
     * 设置请求参数
     * */
    Request setHttpRequestOption(HttpRequestOption requestMeta);

    /**
     * 返回执行流程
     * */
    QuickFlow getExecuteFlow();
}
