package cn.schoolwow.quickhttp.module.request.header;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.request.HttpRequestParent;

import java.nio.charset.Charset;
import java.util.*;

public class RequestHeaderImpl extends HttpRequestParent implements RequestHeader {
    public RequestHeaderImpl(QuickFlow quickFlow) {
        super(quickFlow);
    }

    @Override
    public Request basicAuth(String username, String password) {
        String encoded = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(Charset.forName(httpRequestOption.charset)));
        httpRequestOption.headerMap.put("Authorization", new ArrayList<>(Arrays.asList("Basic " + encoded)));
        return httpRequestContext.request;
    }

    @Override
    public Request charset(String charset) {
        httpRequestOption.charset = charset;
        return httpRequestContext.request;
    }

    @Override
    public Request userAgent(String userAgent) {
        httpRequestOption.headerMap.put("User-Agent", new ArrayList<>(Arrays.asList(userAgent)));
        return httpRequestContext.request;
    }

    @Override
    public Request userAgent(Request.UserAgent userAgent) {
        httpRequestOption.headerMap.put("User-Agent", new ArrayList<>(Arrays.asList(userAgent.userAgent)));
        return httpRequestContext.request;
    }

    @Override
    public Request referrer(String referrer) {
        httpRequestOption.headerMap.put("Referer", new ArrayList<>(Arrays.asList(referrer)));
        return httpRequestContext.request;
    }

    @Override
    public Request contentType(String contentType) {
        httpRequestOption.contentType = contentType;
        return httpRequestContext.request;
    }

    @Override
    public Request contentType(Request.ContentType contentType) {
        httpRequestOption.userContentType = contentType;
        return httpRequestContext.request;
    }

    @Override
    public Request origin() {
        httpRequestOption.origin = true;
        return httpRequestContext.request;
    }

    @Override
    public Request ajax() {
        setHeader("X-Requested-With", "XMLHttpRequest");
        return origin();
    }

    @Override
    public Request ranges(long start, long end) {
        return setHeader("Range", "bytes=" + start + "-" + (end > 0 ? end : ""));
    }

    @Override
    public Request boundary(String boundary) {
        httpRequestOption.boundary = boundary;
        return httpRequestContext.request;
    }

    @Override
    public Request acceptEncoding(boolean acceptEncoding) {
        if(!acceptEncoding){
            httpRequestOption.headerMap.remove("Accept-Encoding");
        }
        return httpRequestContext.request;
    }

    @Override
    public Request addHeader(String name, String value) {
        if(!httpRequestOption.headerMap.containsKey(name)){
            httpRequestOption.headerMap.put(name,new ArrayList<>());
        }
        httpRequestOption.headerMap.get(name).add(value);
        return httpRequestContext.request;
    }

    @Override
    public Request setHeader(String name, String value) {
        httpRequestOption.headerMap.put(name,new ArrayList<>(Arrays.asList(value)));
        return httpRequestContext.request;
    }

    @Override
    public Request headers(Map<String, List<String>> headerMap) {
        httpRequestOption.headerMap.putAll(headerMap);
        return httpRequestContext.request;
    }
}
