package cn.schoolwow.quickhttp.module.request.header;

import cn.schoolwow.quickhttp.domain.execute.Request;

import java.util.List;
import java.util.Map;

/**设置请求头部*/
public interface RequestHeader {
    /**
     * 设置Basic Auth请求头部
     *
     * @param username 用户名
     * @param password 密码
     */
    Request basicAuth(String username, String password);

    /**
     * 指定编码格式
     *
     * @param charset 编码格式
     */
    Request charset(String charset);

    /**
     * 指定用户代理
     *
     * @param userAgent 用户代理
     */
    Request userAgent(String userAgent);

    /**
     * 指定用户代理
     *
     * @param userAgent 用户代理
     */
    Request userAgent(Request.UserAgent userAgent);

    /**
     * 指定referrer
     *
     * @param referrer referrer头部
     */
    Request referrer(String referrer);

    /**
     * 指定Content-Type
     *
     * @param contentType Content-Type头部
     */
    Request contentType(String contentType);

    /**
     * 指定Content-Type
     *
     * @param contentType Content-Type头部
     */
    Request contentType(Request.ContentType contentType);

    /***
     * 设置origin头部
     */
    Request origin();

    /***
     * 设置ajax请求头部
     */
    Request ajax();

    /**
     * 设置分段下载
     *
     * @param start 开始字节
     * @param end   结束字节(0表示获取剩下所有字节)
     */
    Request ranges(long start, long end);

    /**
     * 指定boundary
     *
     * @param boundary boundary
     */
    Request boundary(String boundary);

    /**
     * 是否允许服务端压缩
     * @param acceptEncoding 是否允许服务器开启文件压缩,默认允许
     */
    Request acceptEncoding(boolean acceptEncoding);

    /**
     * 设置头部字段信息
     *
     * @param name  头部字段名称
     * @param value 头部字段值
     */
    Request addHeader(String name, String value);

    /**
     * 设置头部字段信息
     *
     * @param name  头部字段名称
     * @param value 头部字段值
     */
    Request setHeader(String name, String value);

    /**
     * 设置头部字段信息
     *
     * @param headerMap 头部字段信息
     */
    Request headers(Map<String, List<String>> headerMap);
}
