package cn.schoolwow.quickhttp.module.request.execute.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.request.execute.flow.engine.okhttp.SetOkHttpRequestFlow;
import cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.request.PrintHttpHeaderFlow;
import cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.request.SendHttpRequestFlow;
import cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.request.SetKeepAliveSocketFlow;

public class SetHttpRequestServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        switch (httpClientOption.httpExecuteEngine){
            case Raw:{
                //发送请求
                flowContext.executeFlowList(
                        new PrintHttpHeaderFlow(),
                        new SetKeepAliveSocketFlow(),
                        new SendHttpRequestFlow()
                );
            }break;
            case OkHttp:{
                flowContext.executeFlowList(
                        new SetOkHttpRequestFlow()
                );
            }break;
        }
    }

    @Override
    public String name() {
        return "设置http请求服务流程";
    }

}
