package cn.schoolwow.quickhttp.module.request.execute.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.exception.QuickFlowRuntimeException;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.Response;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.request.execute.flow.engine.okhttp.GetOkHttpResponseFlow;
import cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.response.*;
import cn.schoolwow.quickhttp.module.response.HttpResponseInvocationHandler;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;

public class DoExecuteHttpRequestServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        HttpResponseInvocationHandler httpResponseInvocationHandler = new HttpResponseInvocationHandler(flowContext.getQuickFlow());
        Response response = (Response) java.lang.reflect.Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(),
                new Class<?>[]{Response.class}, httpResponseInvocationHandler);
        flowContext.putTemporaryInstanceData(response,Response.class);

        //执行请求
        int retryTimes = 1;
        try {
            IOException ioException = null;
            while (retryTimes <= httpRequestOption.retryTimes) {
                try {
                    switch (httpClientOption.httpExecuteEngine){
                        case Raw:{
                            flowContext.executeFlowList(
                                    new GetResponseHeaderFlow(),
                                    new GetResponseContentStreamFlow(),
                                    new GetResponseCharsetFlow(),
                                    new HandleEventSourceFlow(),
                                    new RedirectFlow()
                            );
                        }break;
                        case OkHttp:{
                            flowContext.executeFlowList(
                                    new GetOkHttpResponseFlow()
                            );
                        }break;
                    }
                    break;
                } catch (QuickFlowRuntimeException e){
                    Exception targetException = e.targetException;
                    if(targetException instanceof SocketTimeoutException || targetException instanceof ConnectException){
                        flowContext.log("链接超时,重试{}/{},地址:{}", retryTimes, httpRequestOption.retryTimes, httpRequestOption.url);
                        httpRequestOption.connectTimeoutMillis = httpRequestOption.connectTimeoutMillis*2;
                        httpRequestOption.readTimeoutMillis = httpRequestOption.readTimeoutMillis*2;
                        retryTimes++;
                        ioException = (IOException) targetException;
                    }else{
                        throw e;
                    }
                }
            }
            if(retryTimes>httpRequestOption.retryTimes&&null!=ioException){
                flowContext.putTemporaryData("executeException", ioException);
            }
        } catch (QuickFlowRuntimeException e) {
            flowContext.putTemporaryData("executeException", e.targetException);
        }
    }

    @Override
    public String name() {
        return "实际执行http请求服务流程";
    }
}
