package cn.schoolwow.quickhttp.module.request.execute.kit;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.domain.execute.Response;
import cn.schoolwow.quickhttp.domain.option.AsyncExecuteHttpListener;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.request.HttpRequestParent;
import cn.schoolwow.quickhttp.module.request.execute.service.ExecuteHttpRequestServiceFlow;

public class RequestExecuteImpl extends HttpRequestParent implements RequestExecute {
    public RequestExecuteImpl(QuickFlow quickFlow) {
        super(quickFlow);
    }
    
    @Override
    public Response execute() {
        FlowContext flowContext = quickFlow.startFlow(new ExecuteHttpRequestServiceFlow()).execute();
        Response response = flowContext.checkInstanceData(Response.class);
        return response;
    }

    @Override
    public void enqueue(AsyncExecuteHttpListener asyncExecuteHttpListener) {
        Request request = quickFlow.getContextInstanceData(Request.class);
        HttpClientOption httpClientOption = quickFlow.getContextInstanceData(HttpClientOption.class);

        httpClientOption.threadPoolExecutor.execute(() -> {
            try {
                Response response = execute();
                asyncExecuteHttpListener.executeSuccess(request, response);
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

}
