package cn.schoolwow.quickhttp.module.request.execute.flow.listener;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.domain.execute.Response;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;

import java.net.HttpCookie;
import java.util.List;

public class AfterExecuteHttpRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        getResponseCookie(flowContext);
        executeListener(flowContext);
    }

    @Override
    public String name() {
        return "执行http请求之后流程";
    }

    private void getResponseCookie(FlowContext flowContext){
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        String[] cookieHeaders = new String[]{"Set-Cookie", "Set-Cookie2"};
        for(String cookieHeader:cookieHeaders){
            if(httpResponseContext.headerMap.containsKey(cookieHeader)){
                for(String setCookie:httpResponseContext.headerMap.get(cookieHeader)){
                    List<HttpCookie> httpCookieList = HttpCookie.parse(setCookie);
                    for(HttpCookie httpCookie:httpCookieList){
                        if(null==httpCookie.getDomain()||httpCookie.getDomain().isEmpty()){
                            httpCookie.setDomain(httpRequestOption.url.getHost());
                        }
                    }
                    httpClientOption.httpCookieList.addAll(httpCookieList);
                    httpResponseContext.httpCookieList.addAll(httpCookieList);
                }
            }
        }
    }

    private void executeListener(FlowContext flowContext) throws Exception {
        Request request = flowContext.checkInstanceData(Request.class);
        Response response = flowContext.checkInstanceData(Response.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        Exception executeException = flowContext.getData("executeException", Exception.class);
        if(null==executeException){
            //请求执行成功
            if(null!=httpClientOption.quickHttpClientListener){
                httpClientOption.quickHttpClientListener.executeSuccess(request, response);
            }
        }else{
            if(null!=httpClientOption.quickHttpClientListener){
                httpClientOption.quickHttpClientListener.executeFail(request, executeException);
            }
            throw executeException;
        }
    }
}
