package cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.response;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.request.execute.service.DoExecuteHttpRequestServiceFlow;
import cn.schoolwow.quickhttp.module.request.execute.service.SetHttpRequestServiceFlow;

public class RedirectFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        //HttpUrlConnection无法处理从http到https的重定向或者https到http的重定向
        int followRedirectTimes = 0;
        String location = httpResponseContext.headerMap.containsKey("Location")?httpResponseContext.headerMap.get("Location").get(0):null;
        while (httpResponseContext.statusCode>=300
                &&httpResponseContext.statusCode<400
                &&httpRequestOption.followRedirects
                && null != location) {
            if (followRedirectTimes >= httpRequestOption.maxFollowRedirectTimes) {
                flowContext.broken("重定向次数超过最大限制!重定向最大次数:"+httpRequestOption.maxFollowRedirectTimes);
            }
            setRedirectRequest(location, flowContext);
            followRedirectTimes++;
            flowContext.log("重定向第"+followRedirectTimes+"/"+httpRequestOption.maxFollowRedirectTimes+",地址:"+location);

            flowContext.executeFlowList(
                    new SetHttpRequestServiceFlow(),
                    new DoExecuteHttpRequestServiceFlow()
            );

            httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);
            location = httpResponseContext.headerMap.containsKey("Location")?httpResponseContext.headerMap.get("Location").get(0):null;
        }
    }

    @Override
    public String name() {
        return "重定向处理";
    }

    /**
     * 设置重定向请求
     * @param location 重定向地址
     * */
    public void setRedirectRequest(String location, FlowContext flowContext){
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);
        Request request = flowContext.checkInstanceData(Request.class);

        //处理相对路径形式的重定向
        if (location.startsWith("http")) {
            request.url(location);
        } else if (location.startsWith("/")) {
            String url = httpRequestOption.url.getProtocol() + "://"
                    + httpRequestOption.url.getHost() + ":"
                    + (httpRequestOption.url.getPort() == -1 ? httpRequestOption.url.getDefaultPort() : httpRequestOption.url.getPort())
                    + location;
            request.url(url);
        } else {
            String u = httpRequestOption.url.toString();
            request.url(u.substring(0, u.lastIndexOf('/')) + "/" + location);
        }

        //301, 308	保留原始方法
        //302, 307	保留原始方法，除非原始方法是 POST，则改为 GET
        //303	强制改为 GET
        switch (httpResponseContext.statusCode){
            case 301:
            case 308:{
                //保留原始方法
            }break;
            case 302:
            case 307:{
                if(Request.Method.POST.equals(httpRequestOption.method)){
                    httpRequestOption.method = Request.Method.GET;
                }
            }break;
            case 303:{
                httpRequestOption.method = Request.Method.GET;
            }break;
        }

        flowContext.putContextTemporaryInstanceData(new HttpResponseContext());
    }

}
