package cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.response;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.module.common.EventSource;
import cn.schoolwow.quickhttp.util.QuickHttpUtil;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class HandleEventSourceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkEventSource(flowContext);
        handleEventSource(flowContext);
    }

    @Override
    public String name() {
        return "处理Event-Source流程";
    }

    /**检查是否可以处理eventSource*/
    private void checkEventSource(FlowContext flowContext){
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        if(null==httpResponseContext.contentType){
            flowContext.brokenCurrentFlow("contentType头部为空!");
        }
        if(!httpResponseContext.contentType.toLowerCase().contains("text/event-stream")){
            flowContext.brokenCurrentFlow("contentType不为text/event-stream!");
        }
        if(null==httpRequestOption.eventSourceConsumer){
            flowContext.brokenCurrentFlow("用户未设置eventSource处理器");
        }
    }

    /**处理eventSource*/
    private void handleEventSource(FlowContext flowContext) throws IOException {
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);
        BufferedInputStream bufferedInputStream = flowContext.checkInstanceData(BufferedInputStream.class);

        EventSource eventSource = null;
        String line = QuickHttpUtil.readLine(bufferedInputStream);
        StringBuilder builder = new StringBuilder();
        while(null!=line){
            if(line.isEmpty()){
                httpRequestOption.eventSourceConsumer.accept(eventSource);
            }else{
                if(null==eventSource){
                    eventSource = new EventSource();
                }
                if(line.startsWith("id:")){
                    eventSource.id = Integer.parseInt(line.substring(line.indexOf(':')+1));
                }
                if(line.startsWith("event:")){
                    eventSource.event = line.substring(line.indexOf(':')+1);
                }
                if(line.startsWith("retry:")){
                    eventSource.retry = Integer.parseInt(line.substring(line.indexOf(':')+1));
                }
                if(line.startsWith("data:")){
                    eventSource.data = line.substring(line.indexOf(':')+1);
                }
            }
            builder.append(line+"\r\n");
            line = QuickHttpUtil.readLine(bufferedInputStream);
        }
        httpResponseContext.body = builder.toString().getBytes(StandardCharsets.UTF_8);
    }
}
