package cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.response;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.util.QuickHttpUtil;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class GetResponseHeaderFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        getResponseLine(flowContext);
        getResponseHeader(flowContext);
    }

    @Override
    public String name() {
        return "获取返回头部信息";
    }

    private void getResponseLine(FlowContext flowContext) throws IOException {
        BufferedInputStream bufferedInputStream = flowContext.checkInstanceData(BufferedInputStream.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        String responseLine = QuickHttpUtil.readLine(bufferedInputStream);
        httpResponseContext.statusLine = responseLine;
        flowContext.log("[返回体状态行]{}",responseLine);

        try {
            int indexOf1 = responseLine.indexOf(" ");
            int indexOf2 = responseLine.indexOf(" ", indexOf1+1);
            String protocol = responseLine.substring(0, indexOf1);
            String statusCodeString = responseLine.substring(indexOf1+1, indexOf2);
            String statusMessage = responseLine.substring(indexOf2+1);

            httpResponseContext.statusCode = Integer.parseInt(statusCodeString);
            httpResponseContext.statusMessage = statusMessage;
        }catch (Exception e){
            throw new IOException("http响应行解析失败!"+responseLine, e);
        }
    }

    private void getResponseHeader(FlowContext flowContext) throws IOException {
        BufferedInputStream bufferedInputStream = flowContext.checkInstanceData(BufferedInputStream.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        String line = QuickHttpUtil.readLine(bufferedInputStream);
        do {
            String headerName = line.substring(0, line.indexOf(":"));
            String headerValue = line.substring(line.indexOf(":")+2);
            flowContext.log("[返回头部]{}:{}",headerName,headerValue);
            if(!httpResponseContext.headerMap.containsKey(headerName)){
                httpResponseContext.headerMap.put(headerName, new ArrayList<>());
            }
            httpResponseContext.headerMap.get(headerName).add(headerValue);
            switch (headerName.toLowerCase()){
                case "content-length":{httpResponseContext.contentLength = Long.parseLong(headerValue);}break;
                case "content-type":{httpResponseContext.contentType = headerValue;}break;
                case "content-encoding":{httpResponseContext.contentEncoding = headerValue;}break;
            }
            line = QuickHttpUtil.readLine(bufferedInputStream);
        }while(!line.isEmpty());
    }

}