package cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.response;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.module.request.execute.domain.ChunkedInputStream;
import cn.schoolwow.quickhttp.module.request.execute.domain.FixedLengthInputStream;
import cn.schoolwow.quickhttp.module.request.execute.domain.SpeedLimitInputStream;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class GetResponseContentStreamFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setResponseInputStream(flowContext);
        checkContentLengthAndTransferEncoding(flowContext);
        handleContentEncoding(flowContext);
        setSpeedLimitStream(flowContext);
    }

    @Override
    public String name() {
        return "获取返回体信息";
    }

    private void setResponseInputStream(FlowContext flowContext){
        BufferedInputStream bufferedInputStream = flowContext.checkInstanceData(BufferedInputStream.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        httpResponseContext.inputStream = bufferedInputStream;
    }

    private void handleContentEncoding(FlowContext flowContext) throws IOException {
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        if(null==httpResponseContext.contentEncoding||httpResponseContext.contentEncoding.isEmpty()){
            return;
        }

        flowContext.log("响应体内容编码格式:{}",httpResponseContext.contentEncoding);
        switch (httpResponseContext.contentEncoding.toLowerCase()){
            case "gzip":{httpResponseContext.inputStream = new GZIPInputStream(httpResponseContext.inputStream);}break;
            case "deflate":{httpResponseContext.inputStream = new InflaterInputStream(httpResponseContext.inputStream, new Inflater(true));}break;
            default:{
                throw new IllegalArgumentException("不支持服务端压缩编码格式!压缩编码格式:"+httpResponseContext.contentEncoding);
            }
        }
    }

    private void checkContentLengthAndTransferEncoding(FlowContext flowContext){
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        if(httpResponseContext.contentLength>0&&httpResponseContext.headerMap.containsKey("Transfer-Encoding")){
            flowContext.log("内容长度:{},传输编码:{}",httpResponseContext.contentLength,httpResponseContext.headerMap.get("Transfer-Encoding"));
            throw new IllegalArgumentException("响应头部同时包含Content-Length和Transfer-Encoding头部!");
        }

        if(httpResponseContext.headerMap.containsKey("Transfer-Encoding")){
            String transferEncoding = httpResponseContext.headerMap.get("Transfer-Encoding").get(0);
            flowContext.log("响应体传输编码格式:{}",transferEncoding);
            if("chunked".equalsIgnoreCase(transferEncoding)){
                httpResponseContext.inputStream = new ChunkedInputStream(httpResponseContext.inputStream);
            }
            //TODO 测试chunked的连接http://www.httpwatch.com/httpgallery/chunked/chunkedimage.aspx
            //25\r\n
            //This is the data in the first chunk\r\n
            //1C\r\n
            //and this is the second one\r\n
            //0\r\n
            //\r\n
        }else if(httpResponseContext.contentLength>0){
            flowContext.log("响应体采用了固定长度模式,长度为"+httpResponseContext.contentLength);
            httpResponseContext.inputStream = new FixedLengthInputStream(httpResponseContext.inputStream, (int) httpResponseContext.contentLength);
        }
    }

    private void setSpeedLimitStream(FlowContext flowContext){
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        httpResponseContext.inputStream = new SpeedLimitInputStream(httpResponseContext.inputStream);
    }
}
