package cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.response;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;

public class GetResponseCharsetFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        if(null==httpResponseContext.contentType||httpResponseContext.contentType.isEmpty()){
            return;
        }

        String prefix = "charset=";
        String contentType = httpResponseContext.contentType;
        if (contentType.contains(prefix)) {
            int startIndex = contentType.indexOf(prefix);
            if (startIndex >= 0) {
                int endIndex = contentType.lastIndexOf(';');
                if (endIndex > startIndex) {
                    httpResponseContext.charset = contentType.substring(startIndex + prefix.length(), endIndex).trim();
                } else if (endIndex < startIndex) {
                    httpResponseContext.charset = contentType.substring(startIndex + prefix.length()).trim();
                }
            }
        }
        if (httpResponseContext.charset == null) {
            httpResponseContext.charset = "utf-8";
        }
    }

    @Override
    public String name() {
        return "获取响应体编码格式流程";
    }

}
