package cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.request;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.common.HttpRequestContext;
import cn.schoolwow.quickhttp.module.request.execute.service.SetHttpRequestServiceFlow;
import cn.schoolwow.quickhttp.util.QuickHttpUtil;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.ArrayBlockingQueue;

public class SetKeepAliveSocketFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setSocketKey(flowContext);
        checkMaxIdleSocket(flowContext);
        getAliveSocket(flowContext);
    }

    @Override
    public String name() {
        return "获取空闲Socket流程";
    }

    private void setSocketKey(FlowContext flowContext) throws IOException {
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);

        int port = httpRequestOption.url.getPort()==-1?httpRequestOption.url.getDefaultPort():httpRequestOption.url.getPort();
        String socketKey = httpRequestOption.url.getProtocol()+"://"+httpRequestOption.url.getHost() + ":" + port;

        flowContext.putCurrentFlowData("port", port);
        flowContext.putCurrentFlowData("socketKey", socketKey);
    }

    private void checkMaxIdleSocket(FlowContext flowContext) throws Exception{
        String socketKey = flowContext.checkData("socketKey", String.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        ArrayBlockingQueue<Socket> arrayBlockingQueue = httpClientOption.keepAliveSocketMap.get(socketKey);
        if(null==arrayBlockingQueue||arrayBlockingQueue.size()<httpClientOption.maxIdleSocketConnection){
            flowContext.log("[获取Socket链接]无空闲连接或空闲连接小于"+httpClientOption.maxIdleSocketConnection+"个!当前个数:"+(null==arrayBlockingQueue?0:arrayBlockingQueue.size()));
            setSocket(flowContext);
            flowContext.brokenCurrentFlow("创建新连接");
        }
    }

    private void getAliveSocket(FlowContext flowContext) throws IOException {
        String socketKey = flowContext.checkData("socketKey", String.class);
        HttpRequestContext httpRequestContext = flowContext.checkInstanceData(HttpRequestContext.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        ArrayBlockingQueue<Socket> arrayBlockingQueue = httpClientOption.keepAliveSocketMap.get(socketKey);

        //获取空闲连接并检查有效性
        while(!arrayBlockingQueue.isEmpty()){
            Socket socket = arrayBlockingQueue.poll();
            try {
                Request request = QuickHttpUtil.newRequestProxy(flowContext.getQuickFlow());

                request.url(socketKey+"/")
                        .method(Request.Method.HEAD);

                flowContext.getQuickFlow().startFlow(new SetHttpRequestServiceFlow())
                        .putTemporaryInstanceData(request, Request.class)
                        .putTemporaryData("socket", socket)
                        .putTemporaryData("testConnection", true)
                        .execute();
                flowContext.log("[获取Socket链接]从空闲连接列表中获取!当前剩余空闲连接个数:"+arrayBlockingQueue.size());
                httpRequestContext.socket = socket;
                return;
            }catch (Exception e){
                e.printStackTrace();
                flowContext.log("[获取Socket链接]连接异常,移除复用的Socket链接!原因:"+e.getMessage());
            }
        }

        //如果所有空闲连接均已失效
        if(null==httpRequestContext.socket){
            flowContext.log("所有空闲连接均已失效");
            setSocket(flowContext);
        }
    }

    private void setSocket(FlowContext flowContext) throws IOException {
        int port = flowContext.checkData("port", int.class);
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);
        HttpRequestContext httpRequestContext = flowContext.checkInstanceData(HttpRequestContext.class);
        
        Socket socket = null;
        switch (httpRequestOption.url.getProtocol().toLowerCase()){
            case "http":{
                socket = null==httpRequestOption.proxy?new Socket():new Socket(httpRequestOption.proxy);
            }break;
            case "https":{
                socket = httpClientOption.sslSocketFactory.createSocket();
            }break;
            default:{
                throw new IllegalArgumentException("不支持该协议访问!协议:"+httpRequestOption.url.getProtocol());
            }
        }

        SocketAddress socketAddress = new InetSocketAddress(httpRequestOption.url.getHost(), port);
        socket.connect(socketAddress, httpRequestOption.connectTimeoutMillis);
        socket.setSoTimeout(httpClientOption.readTimeoutMillis);

        httpRequestContext.socket = socket;
    }
}
