package cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.request;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.module.common.HttpRequestContext;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class SendHttpRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpRequestContext httpRequestContext = flowContext.checkInstanceData(HttpRequestContext.class);
        ByteArrayOutputStream byteArrayOutputStream = flowContext.checkInstanceData(ByteArrayOutputStream.class);

        byteArrayOutputStream.flush();

        byte[] bytes = byteArrayOutputStream.toByteArray();
        httpRequestContext.socket.getOutputStream().write(bytes);
        httpRequestContext.socket.getOutputStream().flush();

        InputStream inputStream = httpRequestContext.socket.getInputStream();
        flowContext.putTemporaryInstanceData(inputStream, InputStream.class);

        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        flowContext.putTemporaryInstanceData(bufferedInputStream, BufferedInputStream.class);
    }

    @Override
    public String name() {
        return "发送http请求";
    }
}
