package cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.request;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.common.DataFileContext;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.common.HttpRequestContext;

import java.io.*;
import java.nio.file.Files;
import java.util.*;

public class PrintHttpHeaderFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setOutputStream(flowContext);
        setRequestBodyStream(flowContext);
        setRequestLine(flowContext);
        setProxyAuthority(flowContext);
        setRequestHeader(flowContext);
        printBody(flowContext);
    }

    @Override
    public String name() {
        return "打印http头部信息";
    }

    private void setOutputStream(FlowContext flowContext) throws UnsupportedEncodingException {
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);

        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        flowContext.putTemporaryInstanceData(byteArrayOutputStream, ByteArrayOutputStream.class);

        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream, httpRequestOption.charset);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);

        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        flowContext.putTemporaryInstanceData(printWriter, PrintWriter.class);
    }

    private void setRequestBodyStream(FlowContext flowContext) throws Exception {
        Request.ContentType contentType = flowContext.getInstanceData(Request.ContentType.class);
        HttpRequestContext httpRequestContext = flowContext.checkInstanceData(HttpRequestContext.class);

        if (null == contentType) {
            return;
        }
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);

        ByteArrayOutputStream requestBodyStream = new ByteArrayOutputStream();
        flowContext.putCurrentFlowData("requestBodyStream", requestBodyStream);

        final BufferedWriter w = new BufferedWriter(new OutputStreamWriter(requestBodyStream, httpRequestOption.charset));

        switch (contentType){
            case MULTIPART_FORMDATA:{
                if (!httpRequestOption.dataMap.isEmpty()) {
                    Set<Map.Entry<String, Object>> entrySet = httpRequestOption.dataMap.entrySet();
                    for (Map.Entry<String, Object> entry : entrySet) {
                        w.write("--" + httpRequestOption.boundary + "\r\n");
                        w.write("Content-Disposition: form-data; name=\"" + entry.getKey().replace("\"", "%22") + "\"\r\n");
                        w.write("\r\n");
                        w.write(entry.getValue().toString());
                        w.write("\r\n");
                    }
                }
                Set<Map.Entry<String, List<DataFileContext>>> entrySet = httpRequestOption.dataFileMap.entrySet();
                for (Map.Entry<String, List<DataFileContext>> entry : entrySet) {
                    for(DataFileContext dataFileContext:entry.getValue()){
                        String name = entry.getKey().replace("\"", "%22");

                        w.write("--" + httpRequestOption.boundary + "\r\n");
                        w.write("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + dataFileContext.filePath.getFileName().toString().replace("\"", "%22") + "\"\r\n");
                        w.write("Content-Type: " + dataFileContext.mimeType + "\r\n");
                        w.write("\r\n");
                        w.flush();
                        requestBodyStream.write(Files.readAllBytes(dataFileContext.filePath));
                        requestBodyStream.flush();
                        w.write("\r\n");
                    }
                }
                w.write("--" + httpRequestOption.boundary + "--\r\n");
            }break;
            case APPLICATION_JSON:
            case APPLICATION_X_WWW_FORM_URLENCODED:{
                if (null != httpRequestOption.requestBody) {
                    requestBodyStream.write(httpRequestOption.requestBody);
                }
            }break;
        }
        w.flush();
        w.close();
        if(requestBodyStream.size()>0){
            httpRequestContext.contentLength = requestBodyStream.size();
        }
    }

    private void setRequestLine(FlowContext flowContext){
        PrintWriter printWriter = flowContext.checkInstanceData(PrintWriter.class);
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);

        StringBuilder requestLineBuilder = new StringBuilder();
        requestLineBuilder.append(httpRequestOption.method.name());
        String path = httpRequestOption.url.getPath();
        if(null==path||path.isEmpty()){
            path = "/";
        }
        requestLineBuilder.append(" "+path);
        String query = httpRequestOption.url.getQuery();
        if(null!=query&&!query.isEmpty()){
            requestLineBuilder.append("?"+query);
        }
        requestLineBuilder.append(" HTTP/1.1");

        flowContext.log("[请求状态行]{}", requestLineBuilder.toString());

        String requestLine = requestLineBuilder.toString();
        printWriter.println(requestLine);
    }

    private void setProxyAuthority(FlowContext flowContext){
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        Request request = flowContext.checkInstanceData(Request.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        if(httpRequestOption.headerMap.containsKey("Proxy-Authorization")){
            return;
        }
        if(null!=httpClientOption.proxyUsername&&null!=httpClientOption.proxyPassword){
            request.proxyAuth(httpClientOption.proxyUsername, httpClientOption.proxyPassword);
        }
    }

    private void setRequestHeader(FlowContext flowContext){
        PrintWriter printWriter = flowContext.checkInstanceData(PrintWriter.class);
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpRequestContext httpRequestContext = flowContext.checkInstanceData(HttpRequestContext.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        httpRequestOption.headerMap.put("Accept-Encoding", Arrays.asList("gzip, deflate"));
        if(null!=httpRequestContext.contentType){
            httpRequestOption.headerMap.put("Content-Type", Arrays.asList(httpRequestContext.contentType));
            flowContext.log("[请求内容类型]{}", httpRequestContext.contentType);
        }
        if(null!=httpRequestContext.contentLength){
            httpRequestOption.headerMap.put("Content-Length", Arrays.asList(httpRequestContext.contentLength+""));
            flowContext.log("[请求内容长度]{}", httpRequestContext.contentLength);
        }
        String host = httpRequestOption.url.getHost()+(httpRequestOption.url.getPort()>0?(":"+httpRequestOption.url.getPort()):"");
        httpRequestOption.headerMap.put("Host", Arrays.asList(host));
        if(httpRequestOption.origin){
            httpRequestOption.headerMap.put("Origin", Arrays.asList(httpRequestOption.url.getProtocol() + "://" + host));
        }

        Map<String,List<String>> requestHeaderMap = new HashMap<>();
        requestHeaderMap.putAll(httpClientOption.globalHeaderMap);
        requestHeaderMap.putAll(httpRequestOption.headerMap);

        for(Map.Entry<String, List<String>> entry:requestHeaderMap.entrySet()){
            for(String value:entry.getValue()){
                flowContext.log("[请求头部]"+entry.getKey()+": "+value);
                printWriter.println(entry.getKey()+": "+value);
            }
        }
    }

    private void printBody(FlowContext flowContext) throws IOException {
        ByteArrayOutputStream requestBodyStream = flowContext.getData("requestBodyStream", ByteArrayOutputStream.class);
        ByteArrayOutputStream byteArrayOutputStream = flowContext.checkInstanceData(ByteArrayOutputStream.class);
        PrintWriter printWriter = flowContext.checkInstanceData(PrintWriter.class);
        Request.ContentType contentType = flowContext.getInstanceData(Request.ContentType.class);
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);

        printWriter.println();
        printWriter.flush();
        if(null==requestBodyStream||requestBodyStream.size()==0){
            return;
        }
        if(null!=contentType){
            switch (contentType){
                case MULTIPART_FORMDATA:{
                    for(Map.Entry<String,List<DataFileContext>> entry:httpRequestOption.dataFileMap.entrySet()){
                        for(DataFileContext dataFileContext:entry.getValue()){
                            File file = dataFileContext.filePath.toFile();
                            flowContext.log("[请求体]参数名:"+entry.getKey()+",文件名:"+file.getName()+",文件大小:"+file.length());
                        }
                    }
                    for(Map.Entry<String,Object> entry:httpRequestOption.dataMap.entrySet()){
                        flowContext.log("[请求体]参数名:"+entry.getKey()+",参数值:"+entry.getValue());
                    }
                }break;
                default:{
                    String content = new String(httpRequestOption.requestBody,httpRequestOption.charset);
                    flowContext.log("[请求体]"+content);
                }break;
            }
        }
        requestBodyStream.writeTo(byteArrayOutputStream);
    }
}
