package cn.schoolwow.quickhttp.module.request.execute.flow.engine.okhttp;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.module.common.DataFileContext;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import okhttp3.*;

import java.io.File;
import java.util.List;
import java.util.Map;

public class SetOkHttpRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        cn.schoolwow.quickhttp.domain.execute.Request.ContentType contentType = flowContext.checkInstanceData(cn.schoolwow.quickhttp.domain.execute.Request.ContentType.class);
        HttpRequestOption httpRequestOption = flowContext.checkInstanceData(HttpRequestOption.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        //TODO 后续优化
        if(null!=httpRequestOption.proxy){
            throw new IllegalArgumentException("OkHttp引擎暂不支持设置HTTP代理");
        }
        Request.Builder requestBuilder = new Request.Builder().url(httpRequestOption.url);
        for(Map.Entry<String, List<String>> entry:httpRequestOption.headerMap.entrySet()){
            for(String value:entry.getValue()){
                requestBuilder.addHeader(entry.getKey(),value);
            }
        }
        if(!httpClientOption.globalHeaderMap.isEmpty()){
            for(Map.Entry<String, List<String>> entry:httpClientOption.globalHeaderMap.entrySet()){
                for(String value:entry.getValue()){
                    requestBuilder.addHeader(entry.getKey(),value);
                }
            }
        }
        switch (contentType){
            case MULTIPART_FORMDATA:{
                MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder()
                        .setType(MultipartBody.FORM);
                for(Map.Entry<String, List<DataFileContext>> entry:httpRequestOption.dataFileMap.entrySet()){
                    for(DataFileContext dataFileContext:entry.getValue()){
                        File file = dataFileContext.filePath.toFile();
                        requestBodyBuilder.addFormDataPart(entry.getKey(),
                                file.getName(),
                                RequestBody.create(file, MediaType.parse(dataFileContext.mimeType)));
                    }
                }
                for(Map.Entry<String,Object> entry:httpRequestOption.dataMap.entrySet()){
                    requestBodyBuilder.addFormDataPart(entry.getKey(), entry.getValue().toString());
                }
                requestBuilder.method(httpRequestOption.method.name(),requestBodyBuilder.build());
            }break;
            case APPLICATION_JSON:{
                String requestString = new String(httpRequestOption.requestBody,httpRequestOption.charset);
                RequestBody requestBody = RequestBody.create(requestString, MediaType.parse("application/json;charset=utf-8"));
                requestBuilder.method(httpRequestOption.method.name(),requestBody);
            }break;
            case APPLICATION_X_WWW_FORM_URLENCODED:{
                switch (httpRequestOption.method){
                    case GET:{requestBuilder.get();}break;
                    case HEAD:{requestBuilder.head();}break;
                    case OPTIONS:
                    case TRACE:{
                    }break;
                    default:{
                        FormBody.Builder formBodyBuilder = new FormBody.Builder();
                        for(Map.Entry<String,Object> entry:httpRequestOption.dataMap.entrySet()){
                            formBodyBuilder.add(entry.getKey(), entry.getValue().toString());
                        }
                        requestBuilder.method(httpRequestOption.method.name(),formBodyBuilder.build());
                    }break;
                }
            }break;
        }
        Request request = requestBuilder.build();
        flowContext.putTemporaryInstanceData(request, okhttp3.Request.class);
    }

    @Override
    public String name() {
        return "设置OKhttp请求对象";
    }
}
