package cn.schoolwow.quickhttp.module.request.execute.flow.engine.okhttp;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.module.request.execute.flow.engine.raw.response.GetResponseCharsetFlow;
import okhttp3.*;

public class GetOkHttpResponseFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Request request = flowContext.checkInstanceData(Request.class);
        OkHttpClient okHttpClient = flowContext.checkInstanceData(OkHttpClient.class);
        HttpResponseContext httpResponseContext = flowContext.checkInstanceData(HttpResponseContext.class);

        Response response = okHttpClient.newCall(request)
                .execute();
        flowContext.putContextTemporaryInstanceData(response, Response.class);

        httpResponseContext.statusCode = response.code();
        httpResponseContext.statusMessage = response.message();

        Headers headers = response.headers();
        for (String name : headers.names()) {
            httpResponseContext.headerMap.put(name, response.headers(name));
        }
        httpResponseContext.contentType = response.header("Content-Type");
        if(null!=httpResponseContext.contentType){
            flowContext.executeFlowList(new GetResponseCharsetFlow());
        }
        ResponseBody responseBody = response.body();
        if(null!=responseBody){
            httpResponseContext.inputStream = responseBody.byteStream();
        }
    }

    @Override
    public String name() {
        return "获取OkHttp引擎执行结果";
    }

}
