package cn.schoolwow.quickhttp.module.request.execute.domain;

import java.io.IOException;
import java.io.InputStream;

public class FixedLengthInputStream extends InputStream {
    private InputStream inputStream;
    private int bytesLeft;

    public FixedLengthInputStream(InputStream inputStream, int length) {
        this.inputStream = inputStream;
        this.bytesLeft = length;
    }

    @Override
    public void mark(int readAheadLimit){
        inputStream.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        inputStream.reset();
    }

    @Override
    public int read() throws IOException {
        if (bytesLeft <= 0) {
            return -1; // 已经读取了指定长度的字节，返回-1表示结束
        }

        int data = inputStream.read();
        if (data != -1) {
            bytesLeft--;
        }

        return data;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (bytesLeft <= 0) {
            return -1; // 已经读取了指定长度的字节，返回-1表示结束
        }

        len = Math.min(len, bytesLeft); // 限制每次读取的长度不超过剩余长度

        int bytesRead = 0;
        while (bytesRead < len) {
            int byteRead = read();
            if (byteRead == -1) {
                break;
            }
            b[off + bytesRead] = (byte) byteRead;
            bytesRead++;
        }

        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        inputStream.close();
    }
}
