package cn.schoolwow.quickhttp.module.request.data;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.common.DataFileContext;
import cn.schoolwow.quickhttp.module.request.HttpRequestParent;
import cn.schoolwow.util.domain.query.reflection.QueryReflection;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RequestDataImpl extends HttpRequestParent implements RequestData {
    public RequestDataImpl(QuickFlow quickFlow) {
        super(quickFlow);
    }
    
    @Override
    public Request parameter(String key, Object value) {
        httpRequestOption.parameterMap.put(key, value);
        return httpRequestContext.request;
    }

    @Override
    public Request parameter(Map<String,Object> parameterMap) {
        httpRequestOption.parameterMap.putAll(parameterMap);
        return httpRequestContext.request;
    }

    @Override
    public Request parameterInstance(Object instance) {
        if(null==instance){
            return httpRequestContext.request;
        }
        List<Field> fieldList = QueryReflection.newQuery(instance.getClass())
                .execute()
                .getFieldList();
        for(Field field:fieldList){
            try {
                Object fieldValue = field.get(instance);
                if(null!=fieldValue){
                    httpRequestOption.parameterMap.put(field.getName(), fieldValue);
                }
            }catch (Exception e){
            }
        }
        return httpRequestContext.request;
    }

    @Override
    public Request data(String key, Object value) {
        httpRequestOption.dataMap.put(key, value);
        return httpRequestContext.request;
    }

    @Override
    public Request dataFile(String key, Path path) {
        return dataFile(key, path);
    }

    @Override
    public Request dataFile(String key, Path path, String mimeType) {
        if(!httpRequestOption.dataFileMap.containsKey(key)){
            httpRequestOption.dataFileMap.put(key,new ArrayList());
        }
        DataFileContext dataFileContext = new DataFileContext();
        dataFileContext.filePath = path;
        dataFileContext.mimeType = mimeType;
        httpRequestOption.dataFileMap.get(key).add(dataFileContext);
        return httpRequestContext.request;
    }

    @Override
    public Request data(Map<String, Object> dataMap) {
        httpRequestOption.dataMap.putAll(dataMap);
        return httpRequestContext.request;
    }

    @Override
    public Request requestBody(String body) {
        httpRequestOption.requestBody = body.getBytes(Charset.forName(httpRequestOption.charset));
        return httpRequestContext.request;
    }

    @Override
    public Request requestBody(JSONObject body) {
        httpRequestOption.requestBody = body.toJSONString().getBytes(Charset.forName(httpRequestOption.charset));
        return httpRequestContext.request;
    }

    @Override
    public Request requestBody(JSONArray body) {
        httpRequestOption.requestBody = body.toJSONString().getBytes(Charset.forName(httpRequestOption.charset));
        return httpRequestContext.request;
    }

    @Override
    public Request requestBody(Path file) {
        try {
            httpRequestOption.requestBody = Files.readAllBytes(file);
            if(null==httpRequestOption.contentType){
                httpRequestOption.contentType = Files.probeContentType(file);
            }
        }catch (IOException e){
            throw new RuntimeException(e);
        }
        return httpRequestContext.request;
    }

    @Override
    public Request instanceRequestBody(Object instance) {
        String requestBody = JSON.toJSONString(instance);
        return requestBody(requestBody);
    }
}
