package cn.schoolwow.quickhttp.module.request.data;

import cn.schoolwow.quickhttp.domain.execute.Request;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.nio.file.Path;
import java.util.Map;

/**设置请求数据*/
public interface RequestData {
    /**
     * 设置路径请求参数
     *
     * @param key   请求参数键
     * @param value 请求参数值
     */
    Request parameter(String key, Object value);

    /**
     * 设置路径请求参数
     *
     * @param parameterMap   请求参数
     */
    Request parameter(Map<String, Object> parameterMap);

    /**
     * 设置路径请求参数
     *
     * @param instance   请求实例
     */
    Request parameterInstance(Object instance);

    /**
     * 设置表单请求参数
     *
     * @param key   表单请求参数键
     * @param value 表单请求参数值
     */
    Request data(String key, Object value);

    /**
     * 设置表单文件参数
     *
     * @param key  表单请求参数键
     * @param path 上传文件
     */
    Request dataFile(String key, Path path);

    /**
     * 设置表单文件参数
     *
     * @param key  表单请求参数键
     * @param path 上传文件
     * @param mimeType 文件MIME类型
     */
    Request dataFile(String key, Path path, String mimeType);

    /**
     * 设置表单请求参数
     *
     * @param dataMap 表单请求
     */
    Request data(Map<String, Object> dataMap);

    /**
     * 设置请求体内容
     *
     * @param body 请求体
     */
    Request requestBody(String body);

    /**
     * 设置请求体内容
     *
     * @param body 请求体
     */
    Request requestBody(JSONObject body);

    /**
     * 设置请求体内容
     *
     * @param body 请求体
     */
    Request requestBody(JSONArray body);

    /**
     * 设置请求体内容
     *
     * @param file 上传文件
     */
    Request requestBody(Path file);

    /**
     * 设置请求体实例内容
     *
     * @param instance 请求体实例
     */
    Request instanceRequestBody(Object instance);
}
