package cn.schoolwow.quickhttp.module.request.cookie;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.module.request.HttpRequestParent;

import java.net.HttpCookie;
import java.util.List;

public class RequestCookieImpl extends HttpRequestParent implements RequestCookie{
    public RequestCookieImpl(QuickFlow quickFlow) {
        super(quickFlow);
    }
    
    @Override
    public Request cookie(String name, String value) {
        HttpCookie httpCookie = new HttpCookie(name,value);
        httpCookie.setMaxAge(3600000);
        httpCookie.setPath("/");
        httpCookie.setHttpOnly(true);
        cookie(httpCookie);
        return httpRequestContext.request;
    }

    @Override
    public Request cookie(String cookie) {
        httpClientOption.cookieOption.addCookieString(httpRequestOption.url.getHost(),cookie);
        return httpRequestContext.request;
    }

    @Override
    public Request cookie(HttpCookie httpCookie) {
        if(null==httpCookie.getDomain()||httpCookie.getDomain().isEmpty()){
            httpCookie.setDomain(httpRequestOption.url.getHost());
        }
        httpCookie.setVersion(0);
        httpCookie.setDiscard(false);
        httpClientOption.cookieOption.addCookie(httpCookie);
        return httpRequestContext.request;
    }

    @Override
    public Request cookie(List<HttpCookie> httpCookieList) {
        for(HttpCookie httpCookie:httpCookieList){
            cookie(httpCookie);
        }
        return httpRequestContext.request;
    }
}
