package cn.schoolwow.quickhttp.module.request.cookie;

import cn.schoolwow.quickhttp.domain.execute.Request;

import java.net.HttpCookie;
import java.util.List;

public interface RequestCookie {
    /**
     * 设置Cookie头部
     *
     * @param name cookie名称
     * @param value cookie值
     */
    Request cookie(String name, String value);

    /**
     * 设置Cookie头部
     *
     * @param cookie cookie字符串
     */
    Request cookie(String cookie);

    /**
     * 设置Cookie头部
     *
     * @param httpCookie cookie信息
     */
    Request cookie(HttpCookie httpCookie);

    /**
     * 设置Cookie头部列表
     *
     * @param httpCookieList cookie列表
     */
    Request cookie(List<HttpCookie> httpCookieList);
}
