package cn.schoolwow.quickhttp.module.request;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.domain.execute.HttpRequestOption;
import cn.schoolwow.quickhttp.domain.execute.HttpResponseContext;
import cn.schoolwow.quickhttp.module.common.HttpRequestContext;
import cn.schoolwow.quickhttp.module.request.cookie.RequestCookieImpl;
import cn.schoolwow.quickhttp.module.request.data.RequestDataImpl;
import cn.schoolwow.quickhttp.module.request.execute.kit.RequestExecuteImpl;
import cn.schoolwow.quickhttp.module.request.header.RequestHeaderImpl;
import cn.schoolwow.quickhttp.module.request.option.kit.RequestOptionImpl;
import cn.schoolwow.quickhttp.module.request.url.kit.RequestUrlImpl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * http请求对象代理对象
 */
public class HttpRequestInvocationHandler implements InvocationHandler {
    private Object[] interfaceInstanceArray;

    public HttpRequestInvocationHandler(QuickFlow executeFlow) {
        //clone方法时会设置HttpRequestOption对象
        if(null==executeFlow.getContextInstanceData(HttpRequestOption.class)){
            executeFlow.putContextTemporaryInstanceData(new HttpRequestOption());
        }
        executeFlow.putContextTemporaryInstanceData(new HttpRequestContext())
                .putContextTemporaryInstanceData(new HttpResponseContext());

        interfaceInstanceArray = new Object[]{
                new RequestUrlImpl(executeFlow),
                new RequestHeaderImpl(executeFlow),
                new RequestCookieImpl(executeFlow),
                new RequestDataImpl(executeFlow),
                new RequestExecuteImpl(executeFlow),
                new RequestOptionImpl(executeFlow)
        };
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        for(Object interfaceInstance:interfaceInstanceArray){
            Class interfaceClass = interfaceInstance.getClass().getInterfaces()[0];
            if(interfaceClass.getSimpleName().equalsIgnoreCase(interfaceName)){
                try {
                    return method.invoke(interfaceInstance, args);
                }catch (InvocationTargetException e){
                    Throwable targetException = e.getTargetException();
                    throw targetException;
                }
            }
        }
        throw new IllegalAccessError("不支持调用该方法!方法名:"+method.getName());
    }
}
