package cn.schoolwow.quickhttp.module.cookie.query.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.net.HttpCookie;
import java.util.List;

public class HasDomainCookieServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String domain = flowContext.checkData("domain", String.class);
        List<HttpCookie> httpCookieList = flowContext.checkData("httpCookieList", List.class);

        flowContext.putData("result", false);
        for (HttpCookie httpCookie : httpCookieList) {
            if (httpCookie.getDomain().contains(domain)) {
                flowContext.putData("result", true);
                return;
            }
        }
    }

    @Override
    public String name() {
        return "域名cookie是否存在服务流程";
    }
}
