package cn.schoolwow.quickhttp.module.cookie.query.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.net.HttpCookie;
import java.util.List;

public class HasCookieServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String domain = flowContext.checkData("domain", String.class);
        String name = flowContext.checkData("name", String.class);
        String value = flowContext.getData("value", String.class);
        List<HttpCookie> httpCookieList = flowContext.checkData("httpCookieList", List.class);

        flowContext.putData("result", false);
        for (HttpCookie httpCookie : httpCookieList) {
            if(!httpCookie.getDomain().contains(domain)){
                continue;
            }
            if(!httpCookie.getName().equals(name)){
                continue;
            }
            if(null!=value&&!value.isEmpty()&&!httpCookie.getValue().equals(value)){
                continue;
            }
            flowContext.putData("result", true);
        }
    }

    @Override
    public String name() {
        return "cookie是否存在服务流程";
    }
}
