package cn.schoolwow.quickhttp.module.cookie.query.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.net.HttpCookie;
import java.util.List;

public class GetCookieStringServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<HttpCookie> httpCookieList = flowContext.checkData("httpCookieList", List.class);

        StringBuilder builder = new StringBuilder();
        for(HttpCookie httpCookie:httpCookieList){
            builder.append(httpCookie.getName()+"="+httpCookie.getValue()+";");
        }
        flowContext.putData("cookieString",builder.toString());
    }

    @Override
    public String name() {
        return "获取Cookie字符串服务流程";
    }
}
