package cn.schoolwow.quickhttp.module.cookie.query.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.net.HttpCookie;
import java.util.List;

public class GetCookieServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String domain = flowContext.checkData("domain", String.class);
        String name = flowContext.checkData("name", String.class);
        List<HttpCookie> httpCookieList = flowContext.checkData("httpCookieList", List.class);

        for (HttpCookie httpCookie : httpCookieList) {
            if (httpCookie.getDomain().contains(domain) && httpCookie.getName().equals(name)) {
                flowContext.putTemporaryInstanceData(httpCookie, HttpCookie.class);
                return;
            }
        }
    }

    @Override
    public String name() {
        return "根据领域和名称获取指定Cookie对象服务流程";
    }
}
