package cn.schoolwow.quickhttp.module.cookie.query.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;

public class GetCookieListServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        switch (httpClientOption.httpExecuteEngine){
            case Raw:{
                flowContext.putTemporaryData("httpCookieList", httpClientOption.httpCookieList);
            }break;
            case OkHttp:{
                flowContext.putTemporaryData("httpCookieList", httpClientOption.httpCookieList);
            }break;
        }
    }

    @Override
    public String name() {
        return "获取Cookie列表对象服务流程";
    }
}
