package cn.schoolwow.quickhttp.module.cookie.query.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;

public class GetCookieListByDomainServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String domain = flowContext.checkData("domain", String.class);
        List<HttpCookie> httpCookieList = flowContext.checkData("httpCookieList", List.class);

        List<HttpCookie> list = new ArrayList<>();
        flowContext.putTemporaryData("list", list);

        for (HttpCookie httpCookie : httpCookieList) {
            if (httpCookie.getDomain().contains(domain)) {
                list.add(httpCookie);
            }
        }
    }

    @Override
    public String name() {
        return "根据领域获取指定Cookie列表对象服务流程";
    }
}
