package cn.schoolwow.quickhttp.module.cookie.query.kit;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickhttp.module.cookie.query.handler.CookieQueryTryCatchFinallyHandler;
import cn.schoolwow.quickhttp.module.cookie.query.service.*;

import java.net.HttpCookie;
import java.util.List;

public class CookieOptionQueryImpl implements CookieOptionQuery{
    private QuickFlow quickFlow;

    public CookieOptionQueryImpl(QuickFlow quickFlow) {
        this.quickFlow = quickFlow;
    }

    @Override
    public boolean hasDomainCookie(String domain) {
        FlowContext flowContext = quickFlow.startFlow(new HasDomainCookieServiceFlow())
                .tryCatchFinallyHandler(new CookieQueryTryCatchFinallyHandler())
                .putData("domain", domain)
                .execute();
        boolean result = flowContext.getData("result", boolean.class,false);
        return result;
    }

    @Override
    public boolean hasCookie(String domain, String name) {
        FlowContext flowContext = quickFlow.startFlow(new HasCookieServiceFlow())
                .tryCatchFinallyHandler(new CookieQueryTryCatchFinallyHandler())
                .putData("domain", domain)
                .putData("name", name)
                .execute();
        boolean result = flowContext.getData("result", boolean.class,false);
        return result;
    }

    @Override
    public boolean hasCookie(String domain, String name, String value) {
        FlowContext flowContext = quickFlow.startFlow(new HasCookieServiceFlow())
                .tryCatchFinallyHandler(new CookieQueryTryCatchFinallyHandler())
                .putData("domain", domain)
                .putData("name", name)
                .putData("value", value)
                .execute();
        boolean result = flowContext.getData("result", boolean.class,false);
        return result;
    }

    @Override
    public String getCookieString(String domain) {
        FlowContext flowContext = quickFlow.startFlow(new GetCookieStringServiceFlow())
                .tryCatchFinallyHandler(new CookieQueryTryCatchFinallyHandler())
                .putData("domain", domain)
                .execute();
        String cookieString = flowContext.getData("cookieString", String.class);
        return cookieString;
    }

    @Override
    public HttpCookie getCookie(String domain, String name) {
        FlowContext flowContext = quickFlow.startFlow(new GetCookieServiceFlow())
                .tryCatchFinallyHandler(new CookieQueryTryCatchFinallyHandler())
                .putData("domain", domain)
                .putData("name", name)
                .execute();
        HttpCookie httpCookie = flowContext.getInstanceData(HttpCookie.class);
        return httpCookie;
    }

    @Override
    public List<HttpCookie> getCookieList(String domain) {
        FlowContext flowContext = quickFlow.startFlow(new GetCookieListByDomainServiceFlow())
                .tryCatchFinallyHandler(new CookieQueryTryCatchFinallyHandler())
                .putData("domain", domain)
                .execute();
        List<HttpCookie> list = flowContext.getData("list", List.class);
        return list;
    }

    @Override
    public List<HttpCookie> getCookieList() {
        FlowContext flowContext = quickFlow.startFlow(new GetCookieListServiceFlow()).execute();
        List<HttpCookie> list = flowContext.getData("httpCookieList", List.class);
        return list;
    }
}
