package cn.schoolwow.quickhttp.module.cookie.query.kit;

import java.net.HttpCookie;
import java.util.List;

/**Cookie选项查询操作*/
public interface CookieOptionQuery {
    /**
     * 指定domain下是否存在cookie
     *
     * @param domain 域名
     */
    boolean hasDomainCookie(String domain);

    /**
     * cookie是否存在
     *
     * @param domain 域名
     * @param name   cookie名称
     */
    boolean hasCookie(String domain, String name);

    /**
     * cookie是否存在
     *
     * @param domain 域名
     * @param name   cookie名称
     */
    boolean hasCookie(String domain, String name, String value);

    /**
     * 获取指定域名下Cookie头部
     * @param domain 域名
     * */
    String getCookieString(String domain);

    /**
     * 获取cookie
     *
     * @param domain 域名
     * @param name   cookie名称
     */
    HttpCookie getCookie(String domain, String name);

    /**
     * 获取指定域名下的Cookie列表
     *
     * @param domain 域名
     */
    List<HttpCookie> getCookieList(String domain);

    /**
     * 获取所有Cookie
     */
    List<HttpCookie> getCookieList();
}
