package cn.schoolwow.quickhttp.module.cookie.query.handler;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import cn.schoolwow.quickhttp.module.cookie.query.service.GetCookieListServiceFlow;

import java.net.HttpCookie;
import java.util.List;

public class CookieQueryTryCatchFinallyHandler implements TryCatchFinallyHandler {
    @Override
    public void handleTryStart(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new GetCookieListServiceFlow());

        List<HttpCookie> httpCookieList = flowContext.getData("httpCookieList", List.class);
        if(null==httpCookieList||httpCookieList.isEmpty()){
            flowContext.broken("cookie列表为空");
        }
    }

    @Override
    public void handleTryEnd(FlowContext flowContext) throws Exception {

    }

    @Override
    public void handleException(FlowContext flowContext, Exception e) {

    }

    @Override
    public void handleFinally(FlowContext flowContext) {

    }

    @Override
    public String name() {
        return "Cookie策略处理器";
    }
}
