package cn.schoolwow.quickhttp.module.cookie.action.service;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.cookie.query.service.GetCookieListServiceFlow;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;

public class AddHttpCookieServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        HttpCookie httpCookie = flowContext.checkInstanceData(HttpCookie.class);
        HttpClientOption httpClientOption = flowContext.checkInstanceData(HttpClientOption.class);

        String domain = httpCookie.getDomain();
        if(null==domain||domain.isEmpty()){
            throw new IllegalArgumentException("cookie的domain属性不能为空!");
        }
        if (domain.startsWith(".")) {
            httpCookie.setDomain("." + domain);
        }
        if(null==httpCookie.getPath()||httpCookie.getPath().isEmpty()){
            httpCookie.setPath("/");
        }
        if (httpCookie.getMaxAge() <= 0) {
            httpCookie.setMaxAge(3600);
        }

        flowContext.executeFlowList(new GetCookieListServiceFlow());
        List<HttpCookie> httpCookieList = flowContext.getData("httpCookieList", List.class, new ArrayList<>());

        boolean httpCookieExists = false;
        for(HttpCookie httpCookie1:httpCookieList){
            if(httpCookie.getDomain().equalsIgnoreCase(httpCookie1.getDomain())&&httpCookie.getName().equalsIgnoreCase(httpCookie1.getName())){
                httpCookie1.setValue(httpCookie.getValue());
                httpCookieExists = true;
                break;
            }
        }
        if(!httpCookieExists){
            switch (httpClientOption.httpExecuteEngine){
                case Raw:{
                    httpCookieList.add(httpCookie);
                }break;
                case OkHttp:{
                    //TODO 暂时不支持手动添加Cookie信息
                }break;
            }
        }
    }

    @Override
    public String name() {
        return "添加HttpCookie对象服务流程";
    }
}
