package cn.schoolwow.quickhttp.module.cookie.action.kit;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.cookie.action.service.AddHttpCookieServiceFlow;
import cn.schoolwow.quickhttp.module.cookie.query.kit.CookieOptionQuery;

import java.net.HttpCookie;
import java.util.List;
import java.util.StringTokenizer;

public class CookieOptionActionImpl implements CookieOptionAction{
    private QuickFlow quickFlow;
    private CookieOptionQuery cookieOptionQuery;

    public CookieOptionActionImpl(QuickFlow quickFlow, CookieOptionQuery cookieOptionQuery) {
        this.quickFlow = quickFlow;
        this.cookieOptionQuery = cookieOptionQuery;
    }

    @Override
    public void addCookieString(String domain, String cookie) {
        addCookieString(domain,"/",cookie);
    }

    @Override
    public void addCookieString(String domain, String path, String cookie) {
        if (null == cookie || cookie.isEmpty()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(cookie, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int startIndex = token.indexOf('=');
            String name = token.substring(0, startIndex).trim();
            String value = token.substring(startIndex + 1).trim();
            addCookie(domain, path, name, value);
        }
    }

    @Override
    public void addCookie(String domain, String name, String value) {
        addCookie(domain,"/",name,value);
    }

    @Override
    public void addCookie(String domain, String path, String name, String value) {
        HttpCookie httpCookie = new HttpCookie(name, value);
        httpCookie.setMaxAge(3600000);
        httpCookie.setDomain(domain);
        httpCookie.setPath(path);
        httpCookie.setVersion(0);
        httpCookie.setDiscard(false);
        httpCookie.setHttpOnly(true);
        addCookie(httpCookie);
    }

    @Override
    public void addCookie(HttpCookie httpCookie) {
        quickFlow.startFlow(new AddHttpCookieServiceFlow())
                .putTemporaryInstanceData(httpCookie, HttpCookie.class)
                .execute();
    }

    @Override
    public void addCookie(List<HttpCookie> httpCookieList) {
        for (HttpCookie httpCookie : httpCookieList) {
            addCookie(httpCookie);
        }
    }

    @Override
    public void removeCookie(String domain) {
        List<HttpCookie> httpCookieList = cookieOptionQuery.getCookieList(domain);
        for(HttpCookie httpCookie:httpCookieList){
            removeCookie(httpCookie);
        }
    }

    @Override
    public void removeCookie(String domain, String name) {
        HttpCookie httpCookie = cookieOptionQuery.getCookie(domain,name);
        removeCookie(httpCookie);
    }

    @Override
    public void removeCookie(HttpCookie httpCookie) {
        HttpClientOption httpClientOption = quickFlow.getContextInstanceData(HttpClientOption.class);
        switch (httpClientOption.httpExecuteEngine){
            case Raw:{
                httpClientOption.httpCookieList.remove(httpCookie);
            }break;
            case OkHttp:{
            }break;
        }
    }

    @Override
    public void clearCookieList() {
        HttpClientOption httpClientOption = quickFlow.getContextInstanceData(HttpClientOption.class);
        switch (httpClientOption.httpExecuteEngine){
            case Raw:{
                httpClientOption.httpCookieList.clear();
            }break;
            case OkHttp:{
                httpClientOption.httpCookieList.clear();
            }break;
        }
    }
}
