package cn.schoolwow.quickhttp.module.cookie.action.kit;

import java.net.HttpCookie;
import java.util.List;

/**Cookie选项更新操作*/
public interface CookieOptionAction {
    /**
     * 添加Cookie
     *
     * @param domain 域名
     * @param cookie Cookie字段
     */
    void addCookieString(String domain, String cookie);

    /**
     * 添加Cookie
     *
     * @param domain 域名
     * @param path 路径
     * @param cookie Cookie字段
     */
    void addCookieString(String domain, String path, String cookie);

    /**
     * 添加Cookie
     *
     * @param domain 域名
     * @param name   cookie键
     * @param value  cookie值
     */
    void addCookie(String domain, String name, String value);

    /**
     * 添加Cookie
     *
     * @param domain 域名
     * @param path 路径
     * @param name   cookie键
     * @param value  cookie值
     */
    void addCookie(String domain, String path, String name, String value);

    /**
     * 添加Cookie
     *
     * @param httpCookie Cookie对象
     */
    void addCookie(HttpCookie httpCookie);

    /**
     * 添加Cookie列表
     *
     * @param httpCookieList Cookie列表
     */
    void addCookie(List<HttpCookie> httpCookieList);

    /**
     * 删除指定域名下所有Cookie
     *
     * @param domain 域名
     */
    void removeCookie(String domain);

    /**
     * 删除指定域名下的指定Cookie
     *
     * @param domain 域名
     * @param name   Cookie名称
     */
    void removeCookie(String domain, String name);

    /**
     * 删除指定Cookie
     *
     * @param httpCookie httpCookie对象
     */
    void removeCookie(HttpCookie httpCookie);

    /**
     * 清空Cookie列表
     */
    void clearCookieList();
}
