package cn.schoolwow.quickhttp.module.cookie;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickhttp.module.cookie.action.kit.CookieOptionActionImpl;
import cn.schoolwow.quickhttp.module.cookie.query.kit.CookieOptionQuery;
import cn.schoolwow.quickhttp.module.cookie.query.kit.CookieOptionQueryImpl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Cookie选项代理对象
 */
public class CookieOptionInvocationHandler implements InvocationHandler {
    private Object[] interfaceInstanceArray;

    public CookieOptionInvocationHandler(QuickFlow quickFlow) {
        CookieOptionQuery cookieOptionQuery = new CookieOptionQueryImpl(quickFlow);

        interfaceInstanceArray = new Object[]{
                cookieOptionQuery,
                new CookieOptionActionImpl(quickFlow,cookieOptionQuery),
        };
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        for(Object interfaceInstance:interfaceInstanceArray){
            Class interfaceClass = interfaceInstance.getClass().getInterfaces()[0];
            if(interfaceClass.getSimpleName().equalsIgnoreCase(interfaceName)){
                try {
                    return method.invoke(interfaceInstance, args);
                }catch (InvocationTargetException e){
                    Throwable targetException = e.getTargetException();
                    throw targetException;
                }
            }
        }
        throw new IllegalAccessError("不支持调用该方法!方法名:"+method.getName());
    }
}
