package cn.schoolwow.quickhttp.module.common;

import cn.schoolwow.quickhttp.domain.client.CookieOption;
import cn.schoolwow.quickhttp.domain.execute.HttpExecuteEngine;
import cn.schoolwow.quickhttp.domain.option.ExecuteFlowListener;
import cn.schoolwow.quickhttp.domain.option.QuickHttpClientListener;

import javax.net.ssl.*;
import java.net.HttpCookie;
import java.net.Proxy;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * http客户端配置项
 */
public class HttpClientOption {
    /**
     * 调试模式
     */
    public boolean debug;

    /**
     * http代理
     */
    public transient Proxy proxy;

    /**
     * http代理认证用户名
     * */
    public String proxyUsername;

    /**
     * http代理认证密码
     * */
    public String proxyPassword;

    /**
     * 连接超时(毫秒)
     */
    public int connectTimeoutMillis = 3000;

    /**
     * 读取超时(毫秒)
     */
    public int readTimeoutMillis = 5000;

    /**
     * 是否自动重定向
     */
    public boolean followRedirects = true;

    /**
     * 最大重定向次数
     */
    public int maxFollowRedirectTimes = 20;

    /**
     * 是否忽略http状态异常
     */
    public boolean ignoreHttpErrors;

    /**
     * 超时重试次数
     */
    public int retryTimes = 3;

    /**
     * Socket链接最大空闲队列
     */
    public int maxIdleSocketConnection = 20;

    /**
     * hostnameVerifier
     */
    public transient HostnameVerifier hostnameVerifier = (s, sslSession) -> true;

    /**
     * sslSocketFactory
     */
    public transient SSLSocketFactory sslSocketFactory;

    {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLSv1.2");
            sslcontext.init(null, new TrustManager[]{new X509ExtendedTrustManager () {
                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {

                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {

                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {

                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {

                }

                @Override
                public void checkClientTrusted(X509Certificate certificates[], String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new java.security.SecureRandom());
            sslSocketFactory = sslcontext.getSocketFactory();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * origin信息
     */
    public String origin;

    /**
     * 全局头部
     */
    public Map<String, List<String>> globalHeaderMap = new ConcurrentHashMap<>();

    /**
     * 事件监听
     */
    public transient QuickHttpClientListener quickHttpClientListener;

    /**
     * 执行流程事件监听
     */
    public transient ExecuteFlowListener executeFlowListener;

    /**
     * Cookie管理
     */
    public transient CookieOption cookieOption;

    /**
     * Cookie列表
     * */
    public transient List<HttpCookie> httpCookieList = new ArrayList<>();

    /**
     * 异步请求线程池配置
     */
    public transient ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);

    /**
     * 空闲Socket队列
     * */
    public transient Map<String, ArrayBlockingQueue<Socket>> keepAliveSocketMap = new ConcurrentHashMap<>();

    /**执行引擎*/
    public transient HttpExecuteEngine httpExecuteEngine = HttpExecuteEngine.Raw;
}