package cn.schoolwow.quickhttp.module.client.okhttp;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;

import java.io.IOException;

public class PrintOkHttpExecuteLogFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        printRequestLog(flowContext);
        printResponseLog(flowContext);
    }

    @Override
    public String name() {
        return "打印OkHttp执行日志流程";
    }

    private void printRequestLog(FlowContext flowContext) throws IOException {
        Request request = flowContext.checkInstanceData(Request.class);
        flowContext.log("[请求状态行]{} {}", request.method(), request.url());
        Headers headers = request.headers();
        for(String headerName:headers.names()){
            for(String headerValue:headers.values(headerName)){
                flowContext.log("[请求头部]"+headerName+": "+headerValue);
            }
        }
        if (null!=request.body()) {
            try (Buffer buffer = new Buffer()) {
                request.body().writeTo(buffer);
                flowContext.log("[请求体]"+buffer.readUtf8());
            }
        }
    }

    private void printResponseLog(FlowContext flowContext){
        Response response = flowContext.checkInstanceData(Response.class);

        flowContext.log("[返回体状态行]{} {}", response.code(), response.message());
        Headers headers = response.headers();
        for(String headerName:headers.names()){
            for(String headerValue:headers.values(headerName)){
                flowContext.log("[返回头部]"+headerName+": "+headerValue);
            }
        }
    }
}
