package cn.schoolwow.quickhttp.module.client.okhttp;

import cn.schoolwow.quickflow.QuickFlow;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;

public class OkHttpExecuteInterceptor implements Interceptor {
    private QuickFlow quickFlow;

    public OkHttpExecuteInterceptor(QuickFlow quickFlow) {
        this.quickFlow = quickFlow;
    }

    @NotNull
    @Override
    public Response intercept(@NotNull Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);

        quickFlow.startFlow(new PrintOkHttpExecuteLogFlow())
                .putTemporaryInstanceData(request, Request.class)
                .putTemporaryInstanceData(response, Response.class)
                .execute();
        return response;
    }
}
