package cn.schoolwow.quickhttp.module.client;

import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import cn.schoolwow.quickhttp.domain.client.CookieOption;
import cn.schoolwow.quickhttp.domain.client.QuickHttpClient;
import cn.schoolwow.quickhttp.domain.client.QuickHttpClientConfig;
import cn.schoolwow.quickhttp.domain.execute.Request;
import cn.schoolwow.quickhttp.domain.websocket.WebSocketClient;
import cn.schoolwow.quickhttp.module.common.HttpClientOption;
import cn.schoolwow.quickhttp.module.webSocket.domain.WebSocketClientConfig;
import cn.schoolwow.quickhttp.module.webSocket.kit.WebSocketClientImpl;
import cn.schoolwow.quickhttp.util.QuickHttpUtil;

/**
 * http客户端
 */
public class QuickHttpClientImpl implements QuickHttpClient {
    private HttpClientOption httpClientOption;
    private QuickHttpClientConfig quickHttpClientConfig;
    private QuickFlow quickFlow;

    public QuickHttpClientImpl(QuickFlow quickFlow) {
        this.quickFlow = quickFlow;
        this.httpClientOption = new HttpClientOption();
        httpClientOption.cookieOption = QuickHttpUtil.newCookieOptionProxy(quickFlow);
        quickFlow.putContextTemporaryInstanceData(httpClientOption);
        quickHttpClientConfig = new QuickHttpClientConfigImpl(quickFlow);
    }

    @Override
    public QuickHttpClientConfig clientConfig() {
        return quickHttpClientConfig;
    }

    @Override
    public CookieOption cookieOption() {
        return httpClientOption.cookieOption;
    }

    @Override
    public Request connect(String url) {
        QuickFlow executeFlow = QuickFlowBuilder.newInstance().parentFlow(quickFlow);
        Request request = QuickHttpUtil.newRequestProxy(executeFlow).url(url);
        return request;
    }

    @Override
    public WebSocketClient connectWebSocket(String url) {
        return new WebSocketClientImpl(url, null, quickFlow);
    }

    @Override
    public WebSocketClient connectWebSocket(String url, WebSocketClientConfig webSocketClientConfig) {
        return new WebSocketClientImpl(url, webSocketClientConfig, quickFlow);
    }
}
