package cn.schoolwow.quickhttp.domain.websocket;

import cn.schoolwow.quickhttp.util.WebSocketUtil;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

/**数据帧*/
public class WebSocketFrame {
    /**是否是最后一个分片*/
    public boolean fin = true;

    /**操作代码*/
    public OPCode opCode;

    /**关闭状态码*/
    public CloseCode closeCode = CloseCode.NORMAL_CLOSURE;

    /**是否进行掩码*/
    public boolean mask;

    /**载荷长度*/
    public long payloadLength;

    /**掩码key(4字节)*/
    public byte[] maskKey;

    /**载荷数据*/
    public byte[] payload;

    public static WebSocketFrame newInstance(){
        return new WebSocketFrame();
    }

    /**指定是否是最后一个分片*/
    public WebSocketFrame fin(boolean fin){
        this.fin = fin;
        return this;
    }

    /**指定操作代码*/
    public WebSocketFrame opCode(OPCode opCode){
        this.opCode = opCode;
        if(OPCode.Close.equals(opCode)){
            closeCode(CloseCode.NORMAL_CLOSURE);
        }
        return this;
    }

    /**指定关闭状态码*/
    public WebSocketFrame closeCode(CloseCode closeCode){
        this.closeCode = closeCode;
        this.payloadLength = 2;
        this.payload = new byte[2];
        this.payload[0] = (byte)(closeCode.code>>8);
        this.payload[1] = (byte)(closeCode.code);
        return this;
    }

    /**指定是否进行掩码*/
    public WebSocketFrame mask(boolean mask){
        this.mask = mask;
        if(mask){
            this.maskKey = new byte[4];
            WebSocketUtil.randomBytes(this.maskKey);
        }
        return this;
    }

    /**指定载荷数据*/
    public WebSocketFrame payload(byte[] payload){
        this.payload = payload;
        this.payloadLength = payload.length;
        return this;
    }

    @Override
    public String toString() {
        return "{" +
                "是否是最后一个分片:" + fin + "," +
                "操作代码:" + opCode.name() + "," +
                "是否进行掩码:" + mask + "," +
                "载荷长度:" + payloadLength + "," +
                "掩码key:" + Arrays.toString(maskKey) + "," +
                "实际载荷数据:" + (OPCode.TextFrame.equals(opCode)?new String(payload, StandardCharsets.UTF_8):WebSocketUtil.byteArrayToHex(payload)) +
                "}";
    }
}